#!/usr/bin/env python
"""
Oto najnowsze wiadomoci
Teleprompter oparty na Raspberry Pi
"""
import time                     # Na potrzeby dodawania opnie
import os, pygame, sys

pygame.init()                   #  Interfejs graficzny
os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Teleprompter")
screenWidth = 980
screenHeight =610
screen = pygame.display.set_mode([screenWidth,screenHeight],0,32)
background = pygame.Surface((screenWidth,screenHeight))
segments = 4
segment = 0 # Punkt pocztkowy
textHeight = screenHeight / segments
textSurface = [ pygame.Surface((screenWidth,textHeight)) for s in range(0,segments+1)]

# Definiowanie kolorw interfejsu uytkownika
cBackground =(0,0,0)
cText = (255,255,255)
scrollSize = 6
background.fill(cBackground) # Okrelanie koloru ta
font = pygame.font.Font(None, textHeight)
numberOfLines = 0
newsLines = list()
fName = "news.txt" # Nazwa uywanego pliku
mirror = False
pause = False
anymore = False

def main():
   global anymore
   while True : 
     getNews()
     lines = 0
     while lines < numberOfLines :
         for i in range(segments, 0, -1): # Przestawianie pl z tekstem
             textSurface[i] = textSurface[i-1]  
         lines = setWords(lines,0)
         offset = 0
         while offset < textHeight:
            checkForEvent()
            if not pause :
               drawScreen(offset)
               offset += scrollSize
     anymore = False
     while not anymore :
        checkForEvent()
            
def getNews():  # Otwieranie pliku z wiadomociami
   global numberOfLines, newsLines
   numberOfLines = 0
   newsLines = list()
   nfile = open(fName,"r")
   for line in nfile.readlines():
        newsLines.append(line)
        numberOfLines +=1
   nfile.close()

def drawScreen(offset) : # Wywietlanie na ekranie
    global segment
    screen.blit(background,[0,0]) # Ustawianie koloru ta
    for index in range(0,segments+1):
      segment +=1
      if(segment > segments): # Zerowanie numeru segmentu
         segment = 0
      drawWords(segment,offset)
    pygame.display.update()
 
def setWords(index,segment) :
        endOfLine = False
        margin = 30 # czna ilo wolnego miejsca po obu stronach
        words = newsLines[index].split() # Tworzenie tablicy sw na podstawie wiersza
        wordsAvailable = len(words)
        wordsToUse = 0
        wordsWidth = 0
        tryLine = ""
        while wordsWidth < screenWidth - margin and wordsAvailable >= wordsToUse + 1:
          tryLine = ""
          wordsToUse += 1
          for test in range(0, wordsToUse):
             tryLine = tryLine + words[test] + " "
          textSurface[segment] = font.render(tryLine, True, cText, cBackground )
          tryWidth = textSurface[segment].get_rect()         
          wordsWidth = tryWidth.right
        useLine = ""
        if  wordsWidth > screenWidth - margin : # Obsuguje koniec wiersza
            wordsToUse -= 1 # Usuwanie ostatniego sowa
        else :
            endOfLine = True
        for test in range(0, wordsToUse): # Tworzenie odpowiedniego wiersza
             useLine = useLine + words[test] + " "
        textSurface[segment] = font.render(useLine, True, cText, cBackground )
        newsLines[index] = newsLines[index][len(useLine) :]
        if endOfLine : # Przejcie do nastpnego wiersza
           index += 1
        return index

def drawWords(index,offset) :
        textRect = textSurface[index].get_rect()
        textRect.centerx = screenWidth / 2
        textRect.top = screenHeight - (textHeight * index) - offset
        if mirror :
           screen.blit(pygame.transform.flip(textSurface[index], True, False), textRect)
        else :
           screen.blit(textSurface[index], textRect)
        
def terminate(): # Zamykanie programu
    print ("Trwa zamykanie programu - prosimy czeka")
    pygame.quit() # Usuwanie obiektu pygame
    sys.exit()
    
def checkForEvent(): # Sprawdzanie, czy naley zamkn program
    global scrollSize, pause, anymore, fName, mirror
    event = pygame.event.poll()
    if event.type == pygame.QUIT :
           terminate()
    if event.type == pygame.KEYDOWN :
        if event.key == pygame.K_ESCAPE :
            terminate()
        if event.key == pygame.K_DOWN :
           scrollSize -= 1
           if scrollSize == 0:
              scrollsize = 1
        if event.key == pygame.K_UP :
           scrollSize += 1
        if event.key == pygame.K_SPACE :
           pause = not pause
        if event.key == pygame.K_m :
           mirror = not mirror
        if event.key == pygame.K_0 :
           anymore = True
           fName = "news.txt"
        if event.key == pygame.K_1 :
           anymore = True
           fName = "news1.txt"
        if event.key == pygame.K_2 :
           anymore = True
           fName = "news2.txt"
        if event.key == pygame.K_3 :
           anymore = True
           fName = "news3.txt"

            
if __name__ == '__main__':
    main()   
